/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import java.io.IOException;
import java.net.URISyntaxException;

import com.inet.report.EngineRenderData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.SwingReportViewer;

/**
 * This sample shows you how you can print a report without the preview in the viewer. This is accomplished by calling
 * {@link ReportView#print(int, int, boolean)}.
 */
public class PrintWithoutPreview {

    private RenderData        renderConnection;  // This is our main render data connection - the source of our raw report data coming from our report server

    private SwingReportViewer viewer;            // Our top-level viewer object

    private ReportView        currentReportView; // Our report view, responsible for a single report

    /**
     * Print a report without the preview in the viewer.
     */
    public PrintWithoutPreview() {
        // to initialize we first create a top level ReportViewer:
        viewer = new SwingReportViewer();

        String reportLocation = "";
        try {
            reportLocation = getClass().getResource( "../sample.rpt" ).toURI().toString();
        } catch( URISyntaxException e ) {
            // Nothing to do
        }

        // then initialize the render data connection.
        renderConnection = new EngineRenderData( "report=" + reportLocation );

        // If you use your own i-net Clear Reports server then use the report URL for this server, e.g.:
        // renderConnection.setReportURL ( "http://serverName:9000/?report=file:c:/java/sample.rpt" );

        // addNewReportView causes a new report view to be created using the given connection as its data source, and then
        // for this newly created report to be added to the viewer.
        currentReportView = viewer.addNewReportView( renderConnection );

        // print entire report with print dialog
        boolean showPrintDialog = true;
        currentReportView.print( 1, -1, showPrintDialog );

        // other possibilities:

        // print only second page of report
        // currentReportView.print( 2, 2, showPrintDialog );

        // print with own PrinterJob
        // currentReportView.print( 1, -1, myPrinterJob );
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     * @throws IOException in case of IO errors. Often the port is already in use.
     */
    public static void main( String[] args ) throws IOException {
        new PrintWithoutPreview();
    }
}
